<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Retraitenp;
use App\Models\Photo;
use Illuminate\Support\Facades\DB;
use Laravel\Fortify\Http\Requests\LoginRequest;
use     Illuminate\Auth\Session;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Carbon\Carbon;
use DateTime;
use IlluminateSupportCarbon;
use PDF;
use Dompdf\Dompdf;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use \NumberFormatter;
class PhotoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $this->validate($request,[
            'fnr' => 'required',
            'name_file' => 'required',
            'image' => 'max:2048'
            ]);
            $pension = DB::table('photos')->where('fnr',$request->fnr)->first();
            if($pension){
                    return back() ->with('success', "LE FNR '$request->fnr' EXISTE DEJA DANS LA BASE VEILLEZ CONTACTEZ L'AMINISTRATEUR !");
                     }
            if(!$pension){
        $retraitenps=DB::table('numero_f_n_r_s')
        ->select('retraitenp_id')
        ->where('fnr',$request->fnr)
        ->avg('retraitenp_id');
            $photos=new Photo;
            if($request->file())
            $name_file = time().'_'.$request->file->getClientOriginalName();
            $filePath = $request->file('file')->storeAs('photos', $name_file, 'public');
            $photos->fnr = $request->input('fnr');
            $photos->name_file = time().'_'.$request->file->getClientOriginalName();
            $photos->image = '/storage_path/' . $filePath;
            $photos->agent = auth()->user()->name;
            $photos->retraitenp_id = $retraitenps;
            $photos->save();

        if (!$photos) {
            return redirect()->back()->with('error', 'SVP, nous avons des difficultés à enregistrer la photo.');
       }
       return redirect()->back()->with('success', 'Success,La photo à ete bien enregistrer.');

    }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
