<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Pgr;
use App\Models\User;
use App\Models\Formalitereversion;
use Illuminate\Support\Facades\DB;
use Laravel\Fortify\Http\Requests\LoginRequest;
use     Illuminate\Auth\Session;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Carbon\Carbon;
use DateTime;
use IlluminateSupportCarbon;
use PDF;
use Dompdf\Dompdf;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use \NumberFormatter;

class PgrController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $pgr= DB::table('pgrs')->select(DB::raw('pgrs.id,nom,pensiongenerale,
        fnr,nature,assignations'))
         ->get();
  
      return view('pgr.gratification', compact('pgr'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'fnr' => 'required'
            ]);
       $pension = DB::table('pgrs')->where('fnr',$request->fnr)->first();
           if($pension){
                   return back() ->with('success', "Cette pension existe deja '$request->fnr' EXISTE DEJA DANS LA BASE VEILLEZ CONTACTEZ L'AMINISTRATEUR !");
                    }
                    if(!$pension){
            $pgrs=new Pgr;
            $pgrs->nom=$request->input('nom');
            $pgrs->pensiongenerale=$request->input('pensiongenerale');
            $pgrs->nature=$request->input('nature');
            $pgrs->fnr=$request->input('fnr');
            $pgrs->assignations=$request->input('assignations');
            $pgrs->user_id = auth()->user()->id;
            $pgrs->save();
        return back()->with('success', 'Le FNR à été enregistrés avec succès.');
       }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $query = DB::table('pgrs')->select(DB::raw('pgrs.id,nom,pensiongenerale,fnr,nature,assignations'))
        ->where('pgrs.id', '=', "$id")
         ->get();
       $qrcode = base64_encode(QrCode::format('svg')->size(50)->errorCorrection('H')->generate('Système de gestion de paiement des pensions du Niger'));
       $pdf = PDF::loadView('pgr.fiche', compact('qrcode','query'));
        $path = 'images/logocareni2.PNG';
        $type = pathinfo($path, PATHINFO_EXTENSION);
        $data = file_get_contents($path);
        $logo = 'data:image/' .$type. ';base64,'. base64_encode($data);
        return $pdf
            ->setPaper('a4', 'P')
            ->stream();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
