<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Pe;
use App\Models\Ppe;
use Illuminate\Support\Facades\DB;
use Laravel\Fortify\Http\Requests\LoginRequest;
use     Illuminate\Auth\Session;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Carbon\Carbon;
use DateTime;
use IlluminateSupportCarbon;
use PDF;
use Dompdf\Dompdf;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use \NumberFormatter;

class PeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $programmation = DB::table('ppes')
        ->leftJoin('pes', 'pe_id', '=', 'pes.numpension')
        ->leftJoin('users', 'ppes.user_id', '=', 'users.id')
        ->select(DB::raw('ppes.id,ppes.numpension,ppes.nom,ppes.matricule,ppes.pensiongenerale,ppes.modepaiement,ppes.assignations,utilisateur'))
         ->where('ppes.modepaiement','=','ESPECES')
         ->where('status_paiement', '=', NULL)
        ->get();
        return view('pensionetranger.listes' ,compact('programmation'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $this->validate($request,[
            'numpension' => 'required'
            ]);
            $fnr = DB::table('ppes')
            ->where('numpension',$request->numpension)
            ->where('debut',$request->debut)
            ->where('fin',$request->fin)
            ->first();
            if($fnr){
                return back() ->with('success', "LE NUMERO EST DEJA PROGRAMME VEILLEZ CONTACTEZ L'AMINISTRATEUR !");
                 }
                 if(!$fnr){
                    $idpe=DB::table('pes')
                    ->select('id')
                    ->where('numpension',$request->numpension)
                    ->avg('id');
                $retraitenps=DB::table('pes')
                ->select('numpension')
                ->where('numpension',$request->numpension)
                ->get();
                foreach ($retraitenps as $retraitenpss)
                $retraitenp=$retraitenpss->numpension;
               // $retraitenp=24;
                $natures =$natures=DB::table('pes')
                ->select('nature')
                ->whereRaw("numpension=$retraitenp")
                ->get();
                $noms =$noms=DB::table('pes')
                ->select('nom')
                ->whereRaw("numpension=$retraitenp")
                ->get();
                $matricules =$matricules=DB::table('pes')
                ->select('matricule')
                ->whereRaw("numpension=$retraitenp")
                ->get();
                $assignationss =$assignationss=DB::table('pes')
                ->select('assignations')
                ->whereRaw("numpension=$retraitenp")
                ->get();
                $modepaiements =$modepaiements=DB::table('pes')
                ->select('modepaiement')
                ->whereRaw("numpension=$retraitenp")
                ->get();
                $domiciliations =$domiciliations=DB::table('pes')
                ->select('domiciliation')
                ->whereRaw("numpension=$retraitenp")
                ->get();
                $numerocomptes =$numerocomptes=DB::table('pes')
                ->select('numerocompte')
                ->whereRaw("numpension=$retraitenp")
                ->get();
                $pensiongenerales =$pensiongenerales=DB::table('pes')
                ->select('pensiongenerale')
                ->whereRaw("numpension=$retraitenp")
                ->get();
                $elementpensions =$elementpensions=DB::table('pes')
                ->select('elementpension')
                ->whereRaw("numpension=$retraitenp")
                ->get();
                $codes =$codes=DB::table('pes')
                ->select('code')
                ->whereRaw("numpension=$retraitenp")
                ->get();
                $groupes =$groupes=DB::table('pes')
                ->select('groupe')
                ->whereRaw("numpension=$retraitenp")
                ->get();
                $numeroordres =$numeroordres=DB::table('pes')
                ->select('numeroordre')
                ->whereRaw("numpension=$retraitenp")
                ->get();
                $pes=new Ppe;
                $pes->numpension=$request->input('numpension');
                foreach ($natures as $nature)
                $pes->nature=$nature->nature;
                foreach ($noms as $nom)
                $pes->nom=$nom->nom;
                foreach ($matricules as $matricule)
                $pes->matricule=$matricule->matricule;
                foreach ($assignationss as $assignations)
                $pes->assignations=$assignations->assignations;
                foreach ($modepaiements as $modepaiement)
                $pes->modepaiement=$modepaiement->modepaiement;
                foreach ($domiciliations as $domiciliation)
                $pes->domiciliation=$domiciliation->domiciliation;
                foreach ($numerocomptes as $numerocompte)
                $pes->numerocompte=$numerocompte->numerocompte;
                foreach ($elementpensions as $elementpension)
                $pes->elementpension=$elementpension->elementpension;
                foreach ($pensiongenerales as $pensiongenerale)
                $pes->pensiongenerale=$pensiongenerale->pensiongenerale;
                foreach ($codes as $code)
                $pes->code=$code->code;
                foreach ($groupes as $groupe)
                $pes->groupe=$groupe->groupe;
                foreach ($numeroordres as $numeroordre)
                $pes->numeroordre=$numeroordre->numeroordre;
                 $pes->debut=$request->input('debut');
                 $pes->fin=$request->input('fin');
                 $pes->user_id=auth()->user()->id;
                 $pes->pe_id=$idpe;
                  $pes->utilisateur=auth()->user()->name;
                 $pes->save();
               
        return back() ->with('success', "LE MONTANT de la PENSION est $pes->pensiongenerale");
            
        }
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'numpension' => 'required',
            'nature' => 'required',
            'nom' => 'required',
            'matricule' => 'required',
            'assignations' => 'required'
           
          ]);
          $pension = DB::table('pes')
          ->where('numpension',$request->numpension)
          ->first();
          if($pension){
                  return back() ->with('success', "CETTE NUMERO EXISTE DEJA DANS LA BASE VEILLEZ CONTACTEZ L'AMINISTRATEUR !");
                   }
                   if(!$pension){
              $ops=new Pe;
             $ops->numpension=$request->input('numpension');
             $ops->nature = $request->input('nature');
               $ops->nom = $request->input('nom');
               $ops->matricule = $request->input('matricule');
               $ops->assignations = $request->input('assignations');
               $ops->domiciliation = $request->input('domiciliation');
               $ops->modepaiement = $request->input('modepaiement');
               $ops->numerocompte = $request->input('numerocompte');
               $ops->elementpension = $request->input('elementpension');
               $ops->pensiongenerale = $request->input('pensiongenerale');
               $ops->code = $request->input('code');
               $ops->groupe = $request->input('groupe');
               $ops->numeroordre = $request->input('numeroordre');
               $ops->user_id = auth()->user()->id;
               $ops->save();
       return back()->with('success', 'Les données ont été enregistrées avec succès.');
      }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $caisse = DB::table('ppes')
        ->leftJoin('pes', 'pe_id', '=', 'pes.numpension')
        ->leftJoin('users', 'ppes.user_id', '=', 'users.id')
        ->select(DB::raw('ppes.id,ppes.numpension,ppes.nom,ppes.matricule,ppes.pensiongenerale,ppes.modepaiement,ppes.assignations,utilisateur'))
         ->where('ppes.modepaiement','=','ESPECES')
         ->where('status_paiement', '=', NULL)
         ->where('ppes.id', '=', "$id")
        ->get();
        if(count($caisse)>0){
            return view('pensionetranger.edit' ,compact('caisse'));
          }
          else{
            return back() ->with('success', "BULLETIN dèjà tirer");
          }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $paiment= Ppe::find($id);
      $paiment->status_paiement ="Payer";
      $paiment->ref_carte =$request->input('ref_carte');
      $paiment->date_paiement =\Carbon\Carbon::now();;
      $paiment->agent_pay = auth()->user()->name;
     $paiment->save();


     $query = DB::table('ppes')
     ->leftJoin('pes', 'pe_id', '=', 'pes.numpension')
     ->leftJoin('users', 'ppes.user_id', '=', 'users.id')
     ->select(DB::raw('ppes.id,ppes.numpension,ppes.nom,ppes.matricule,ppes.pensiongenerale,ppes.modepaiement,ppes.assignations,utilisateur,
     ppes.nature,ppes.domiciliation,ppes.numerocompte,ppes.elementpension,ppes.code,ppes.groupe,
     ppes.numeroordre,ppes.date_paiement,ppes.ref_carte,ppes.agent_pay,ppes.debut,ppes.fin'))
      ->where('ppes.modepaiement','=','ESPECES')
      ->where('ppes.id', '=', "$id")
      ->get();

     $qrcode = base64_encode(QrCode::format('svg')->size(50)->errorCorrection('H')->generate('Système de gestion de paiement des pensions du Niger'));
     $pdf = PDF::loadView('pensionetranger.bulletin', compact('qrcode','query'));
      $path = 'images/logocareni2.PNG';
      $type = pathinfo($path, PATHINFO_EXTENSION);
      $data = file_get_contents($path);
      $logo = 'data:image/' .$type. ';base64,'. base64_encode($data);
      return $pdf
      ->setPaper('a3', 'landscape')
          ->stream();
    }
    public function journal(Request $request)  
    {   
    
      $localite=auth()->user()->localite;
      set_time_limit(0);
      $old_limit = ini_set("memory_limit", "3G");
       $_agent=auth()->user()->name;
        $datedebut=date('Y-m-d', strtotime($request->from));
        $date1=date('Y-m-d', strtotime($request->to));
        $datefin=date('Y-m-d', strtotime($request->to));
        $query =DB::table('ppes')
        ->Join('users', 'ppes.user_id', '=', 'users.id')
        ->select(DB::raw('ppes.id,ppes.numpension,ppes.nom,ppes.matricule,ppes.pensiongenerale,ppes.modepaiement,ppes.assignations,utilisateur,
        ppes.nature,ppes.domiciliation,ppes.numerocompte,ppes.elementpension,ppes.code,ppes.groupe,
        ppes.numeroordre,ppes.date_paiement,ppes.ref_carte,ppes.agent_pay,ppes.debut,ppes.fin,agent_pay'))
        ->where('agent_pay','=',"$_agent")
        ->where('status_paiement', '=', 'Payer')
        ->where('date_paiement', '>=', "$datedebut")
         ->where('date_paiement', '<=', "$datefin. ' 23:59:59'")
         ->orderBy('date_paiement')
        ->get();
        $somme = DB::table('ppes')
       ->Join('users', 'ppes.user_id', '=', 'users.id')
        ->select(DB::raw('ppes.id,ppes.numpension,ppes.nom,ppes.matricule,ppes.pensiongenerale,ppes.modepaiement,ppes.assignations,utilisateur,
        ppes.nature,ppes.domiciliation,ppes.numerocompte,ppes.elementpension,ppes.code,ppes.groupe,
        ppes.numeroordre,ppes.date_paiement,ppes.ref_carte,ppes.agent_pay,ppes.debut,ppes.fin'))
        ->where('agent_pay','=',"$_agent")
        ->where('status_paiement', '=', 'Payer')
        ->where('date_paiement', '>=', "$datedebut")
         ->where('date_paiement', '<=', "$datefin. ' 23:59:59'")
         ->orderBy('date_paiement')
           ->sum( 'pensiongenerale' );
        
        if(count($query)>0){
       $qrcode = base64_encode(QrCode::format('svg')->size(50)->errorCorrection('H')->generate('Système de gestion de paiement des pensions du Niger'));
           $pdf = PDF::loadView('pensionetranger.brouillardpe', compact('qrcode','query','datedebut','date1','somme'));
            $path = 'images/logocareni2.PNG';
            $type = pathinfo($path, PATHINFO_EXTENSION);
            $data = file_get_contents($path);
            $logo = 'data:image/' .$type. ';base64,'. base64_encode($data);
            return $pdf
                ->setPaper('a4', 'P')
                ->stream();
             }
               if(count($query)==0){
                 return back() ->with('success', "VEILLEZ SAISIR UNE BONNE PLAGE DE DATE !");
                  }
    
                  
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
